/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker.platform.services.IPlatformHelper;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeElvenTrade;

@Document(value="mods/Botania/recipe/manager/ElvenTradeRecipeManager")
@ZenRegister
@IRecipeHandler.For(value=IElvenTradeRecipe.class)
@ZenCodeType.Name(value="mods.botania.recipe.manager.ElvenTradeRecipeManager")
public class ElvenTradeRecipeManager
implements IRecipeManager<IElvenTradeRecipe>,
IRecipeHandler<IElvenTradeRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack[] outputs, IIngredient ... inputs) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = CraftTweakerConstants.rl((String)name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)new RecipeElvenTrade(resourceLocation, (ItemStack[])Arrays.stream(outputs).map(IItemStack::getInternal).toArray(ItemStack[]::new), (Ingredient[])Arrays.stream(inputs).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new))));
    }

    @ZenCodeType.Method
    public void remove(IIngredient output) {
        this.remove(new IIngredient[]{output});
    }

    @ZenCodeType.Method
    public void remove(IIngredient[] outputs) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> {
            if (recipe.getOutputs().size() != outputs.length) {
                return false;
            }
            List<IItemStack> collected = recipe.getOutputs().stream().map(arg_0 -> ((IPlatformHelper)Services.PLATFORM).createMCItemStack(arg_0)).toList();
            return IntStream.range(0, outputs.length).allMatch(i -> outputs[i].matches((IItemStack)collected.get(i)));
        }));
    }

    public RecipeType<IElvenTradeRecipe> getRecipeType() {
        return ModRecipeTypes.ELVEN_TRADE_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, IElvenTradeRecipe recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(recipe.getOutputs().stream().map(arg_0 -> ((IPlatformHelper)Services.PLATFORM).createMCItemStack(arg_0)).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(", ", "[", "]")));
        recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).forEach(s::add);
        return s.toString();
    }

    public Optional<Function<ResourceLocation, IElvenTradeRecipe>> replaceIngredients(IRecipeManager manager, IElvenTradeRecipe recipe, List<IReplacementRule> rules) {
        if (recipe.getOutputs().size() == 1 && recipe.m_7527_().size() == 1 && recipe.containsItem(recipe.getOutputs().get(0))) {
            return Optional.empty();
        }
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.m_7527_(), Ingredient.class, (Recipe)recipe, rules, ingr -> id -> new RecipeElvenTrade((ResourceLocation)id, recipe.getOutputs().toArray(new ItemStack[0]), (Ingredient[])ingr.toArray((Object[])new Ingredient[0])));
    }
}

